<?php 
require_once 'config.php';
session_start();

// Check if user is logged in and is admin, if not redirect to login
if (!isset($_SESSION['user_id']) || $_SESSION['user_type'] !== 'admin') {
    header('Location: admin-login.php');
    exit();
}
?><!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Dashboard | Cleaning Service</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        :root {
            --primary-color: #109c3d;
            --primary-dark: #0f8c3d;
            --light-bg: #f8fbff;
            --border-color: rgba(16, 156, 61, 0.2);
            --danger: #ef4444;
            --warning: #fbbf24;
            --info: #3b82f6;
        }

        * {
            transition: all 0.3s ease;
        }

        body {
            background: linear-gradient(135deg, #f8fbff, #f1f5f4);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .dashboard-wrapper {
            display: grid;
            grid-template-columns: 280px 1fr;
            gap: 0;
            min-height: 100vh;
        }

        .sidebar {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 30px 20px;
            position: sticky;
            top: 0;
            height: auto;
            overflow-y: auto;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .sidebar-brand {
            font-weight: 700;
            font-size: 18px;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            gap: 10px;
            padding-bottom: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
        }

        .sidebar-menu {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .sidebar-menu li {
            margin-bottom: 10px;
        }

        .sidebar-menu a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            padding: 12px 15px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 14px;
        }

        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: rgba(255, 255, 255, 0.2);
            color: white;
        }

        .sidebar-menu i {
            width: 20px;
            text-align: center;
        }

        .sidebar-divider {
            height: 1px;
            background: rgba(255, 255, 255, 0.2);
            margin: 20px 0;
        }

        .logout-btn {
            margin-top: 30px;
            padding-top: 30px;
            border-top: 1px solid rgba(255, 255, 255, 0.2);
        }

        .main-content {
            padding: 30px;
            overflow-y: auto;
        }

        .header-section {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 40px;
            flex-wrap: wrap;
            gap: 20px;
        }

        .header-section h1 {
            font-size: 32px;
            font-weight: 700;
            color: #0f172a;
        }

        .admin-profile {
            display: flex;
            align-items: center;
            gap: 15px;
            background: white;
            padding: 15px 20px;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }

        .avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: var(--primary-color);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 18px;
        }

        .content-section {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
            margin-bottom: 30px;
        }

        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            flex-wrap: wrap;
            gap: 15px;
        }

        .section-header h2 {
            font-size: 22px;
            font-weight: 700;
            color: #0f172a;
        }

        .btn-primary-custom {
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-primary-custom:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(16, 156, 61, 0.3);
        }

        .btn-danger {
            background: var(--danger);
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            font-weight: 600;
        }

        .btn-danger:hover {
            background: #dc2626;
        }

        .btn-edit {
            background: var(--info);
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            font-weight: 600;
            margin-right: 5px;
        }

        .btn-edit:hover {
            background: #1d4ed8;
        }

        .btn-approve {
            background: #10b981;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            font-weight: 600;
            margin-right: 5px;
        }

        .btn-approve:hover {
            background: #059669;
        }

        .btn-reject {
            background: var(--warning);
            color: #000;
            border: none;
            padding: 6px 12px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            font-weight: 600;
            margin-right: 5px;
        }

        .btn-reject:hover {
            background: #f59e0b;
        }

        .data-table {
            overflow-x: auto;
        }

        .data-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .data-table thead {
            background: var(--light-bg);
        }

        .data-table th {
            padding: 15px;
            text-align: left;
            font-weight: 600;
            color: #0f172a;
            border-bottom: 2px solid var(--border-color);
        }

        .data-table th:first-child {
            width: 100px;
            text-align: center;
        }

        .data-table td {
            padding: 15px;
            border-bottom: 1px solid var(--border-color);
            color: #64748b;
        }

        .data-table td:first-child {
            text-align: center;
            padding: 10px;
        }

        .data-table img {
            max-width: auto;
            height: auto;
            border-radius: 4px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .status-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }

        .status-pending {
            background: rgba(251, 191, 36, 0.1);
            color: #d97706;
        }

        .status-confirmed {
            background: rgba(59, 130, 246, 0.1);
            color: #2563eb;
        }

        .status-completed {
            background: rgba(16, 156, 61, 0.1);
            color: var(--primary-color);
        }

        .status-cancelled {
            background: rgba(239, 68, 68, 0.1);
            color: var(--danger);
        }

        .nav-tabs {
            display: flex;
            gap: 10px;
            border-bottom: 2px solid var(--border-color);
            margin-bottom: 25px;
            flex-wrap: wrap;
        }

        .nav-tab {
            background: none;
            border: none;
            color: #64748b;
            padding: 12px 20px;
            cursor: pointer;
            font-weight: 600;
            border-bottom: 3px solid transparent;
            transition: all 0.3s ease;
        }

        .nav-tab.active {
            color: var(--primary-color);
            border-bottom-color: var(--primary-color);
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        /* Modal Styles */
        .modal-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            animation: fadeIn 0.3s ease;
        }

        .modal-overlay.active {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .modal-content {
            background: white;
            border-radius: 15px;
            padding: 30px;
            max-width: 600px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
            animation: slideUp 0.3s ease;
        }

        @keyframes slideUp {
            from {
                transform: translateY(50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            border-bottom: 1px solid var(--border-color);
            padding-bottom: 15px;
        }

        .modal-header h3 {
            font-size: 20px;
            font-weight: 700;
            color: #0f172a;
            margin: 0;
        }

        .modal-close {
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: #64748b;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            font-weight: 600;
            color: #0f172a;
            margin-bottom: 8px;
            display: block;
        }

        .form-control {
            width: 100%;
            padding: 12px;
            border: 1px solid var(--border-color);
            border-radius: 8px;
            font-size: 14px;
            font-family: inherit;
            background: white;
        }

        textarea.form-control {
            resize: vertical;
            min-height: 100px;
            padding: 12px;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(16, 156, 61, 0.1);
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
        }

        .form-row.full-width {
            grid-template-columns: 1fr;
        }

        .modal-footer {
            display: flex;
            gap: 10px;
            justify-content: flex-end;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid var(--border-color);
            flex-wrap: wrap;
        }

        .btn-modal-cancel {
            background: #e5e7eb;
            color: #374151;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
        }

        .btn-modal-cancel:hover {
            background: #d1d5db;
        }

        .btn-modal-submit {
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
        }

        .btn-modal-submit:hover {
            background: var(--primary-dark);
        }

        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            animation: slideDown 0.3s ease;
        }

        @keyframes slideDown {
            from {
                transform: translateY(-20px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .alert-success {
            background: rgba(16, 156, 61, 0.1);
            color: var(--primary-color);
            border-left: 4px solid var(--primary-color);
        }

        .alert-danger {
            background: rgba(239, 68, 68, 0.1);
            color: var(--danger);
            border-left: 4px solid var(--danger);
        }

        .loading {
            text-align: center;
            padding: 40px 20px;
            color: #64748b;
        }

        .spinner {
            border: 4px solid var(--light-bg);
            border-top: 4px solid var(--primary-color);
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        @media (max-width: 768px) {
            .dashboard-wrapper {
                grid-template-columns: 1fr;
            }

            .sidebar {
                position: fixed;
                left: -280px;
                width: 280px;
                height: 100vh;
                z-index: 1000;
                transition: left 0.3s ease;
            }

            .sidebar.active {
                left: 0;
            }

            .main-content {
                padding: 20px;
            }

            .header-section h1 {
                font-size: 24px;
            }

            .content-section {
                padding: 20px;
            }

            .data-table {
                font-size: 12px;
            }

            .data-table th,
            .data-table td {
                padding: 10px;
            }

            .toggle-sidebar {
                display: inline-block;
                background: var(--primary-color);
                color: white;
                border: none;
                padding: 10px 15px;
                border-radius: 8px;
                cursor: pointer;
                font-size: 16px;
                margin-bottom: 20px;
            }

            .section-header {
                flex-direction: column;
                align-items: flex-start;
            }

            .admin-profile {
                flex-direction: column;
                align-items: center;
                text-align: center;
                width: 100%;
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .modal-content {
                max-width: 95%;
                width: 95%;
                padding: 20px;
                margin: 10px;
            }

            .modal-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
                margin-bottom: 15px;
            }

            .modal-header h3 {
                width: 100%;
                font-size: 18px;
                margin: 0;
            }

            .modal-close {
                align-self: flex-end;
                margin-top: -25px;
            }

            .modal-footer {
                gap: 8px;
                justify-content: stretch;
                flex-wrap: wrap;
            }

            .btn-modal-cancel,
            .btn-modal-submit {
                flex: 1;
                min-width: 80px;
                padding: 10px;
            }

            .form-group {
                margin-bottom: 15px;
            }

            .form-control {
                padding: 10px;
                font-size: 16px;
            }
        }

        @media (max-width: 480px) {
            .header-section h1 {
                font-size: 20px;
            }

            .section-header h2 {
                font-size: 18px;
            }

            .content-section {
                padding: 15px;
            }

            .data-table {
                overflow-x: auto;
                font-size: 11px;
            }

            .data-table th,
            .data-table td {
                padding: 8px;
            }

            .modal-content {
                width: 100%;
                max-width: 100vw;
                padding: 15px;
                border-radius: 8px;
                max-height: calc(100vh - 20px);
            }

            .modal-header h3 {
                font-size: 16px;
            }

            .form-group label {
                font-size: 13px;
                font-weight: 600;
            }

            .form-control {
                padding: 8px;
                font-size: 14px;
            }

            .btn-modal-cancel,
            .btn-modal-submit {
                font-size: 13px;
                padding: 8px 12px;
            }

            .btn-primary-custom,
            .btn-edit,
            .btn-danger,
            .btn-approve,
            .btn-reject {
                width: 100%;
                margin-bottom: 10px;
            }
        }

        /* Image Upload Section Styles */
        .image-upload-section {
            transition: all 0.3s ease !important;
        }

        .image-upload-section:hover {
            border-color: #0f7938 !important;
            background: #ecf9f1 !important;
        }

        #sliderImagePreview {
            text-align: center;
        }

        #imagePreviewImg {
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        @media (max-width: 768px) {
            .image-upload-section {
                padding: 15px !important;
            }

            .image-upload-section i {
                font-size: 30px !important;
            }

            .image-upload-section p {
                font-size: 13px !important;
            }

            #imagePreviewImg {
                max-height: 200px !important;
            }
        }

        @media (max-width: 480px) {
            .image-upload-section {
                padding: 10px !important;
                margin-bottom: 15px;
            }

            .image-upload-section i {
                font-size: 25px !important;
                margin-bottom: 5px !important;
            }

            .image-upload-section p {
                font-size: 12px !important;
                margin: 3px 0 !important;
            }

            #imagePreviewImg {
                max-height: 150px !important;
            }

            .btn-danger {
                width: 100%;
                padding: 8px !important;
                font-size: 12px;
            }
        }
    </style>
</head>
<body>

    <div class="dashboard-wrapper">
        <!-- Sidebar Navigation -->
        <div class="sidebar" id="sidebar">
            <div class="sidebar-brand">
                <i class="fa-solid fa-chart-pie"></i>
                Admin Panel
            </div>
            <ul class="sidebar-menu">
                <li><a href="#dashboard" class="menu-link active" data-tab="dashboard"><i class="fa-solid fa-gauge"></i> Dashboard</a></li>
                <li><a href="#profile" class="menu-link" data-tab="profile"><i class="fa-solid fa-user"></i> Profile</a></li>
                <li><a href="#staff" class="menu-link" data-tab="staff"><i class="fa-solid fa-users-gear"></i> Staff Management</a></li>
                <li><a href="#assignments" class="menu-link" data-tab="assignments"><i class="fa-solid fa-tasks"></i> Task Assignments</a></li>
                <li><a href="#reservations" class="menu-link" data-tab="reservations"><i class="fa-solid fa-calendar-check"></i> Reservations</a></li>
                <li><a href="#customers" class="menu-link" data-tab="customers"><i class="fa-solid fa-users"></i> Customers</a></li>
                <li><a href="#services" class="menu-link" data-tab="services"><i class="fa-solid fa-briefcase"></i> Services</a></li>
                <li><a href="#team" class="menu-link" data-tab="team"><i class="fa-solid fa-people-group"></i> Team</a></li>
                <li><a href="#blog" class="menu-link" data-tab="blog"><i class="fa-solid fa-pen-nib"></i> Blog</a></li>
                <li><a href="#gallery" class="menu-link" data-tab="gallery"><i class="fa-solid fa-images"></i> Gallery</a></li>
                <li><a href="#hero-slider" class="menu-link" data-tab="hero-slider"><i class="fa-solid fa-sliders"></i> Hero Slider</a></li>
                
                <div class="sidebar-divider"></div>
                
                <li><a href="#contact" class="menu-link" data-tab="contact"><i class="fa-solid fa-envelope"></i> Contact Messages</a></li>
                <li><a href="#feedback" class="menu-link" data-tab="feedback"><i class="fa-solid fa-star"></i> Feedback</a></li>
                
                <li class="logout-btn"><a href="logout.php"><i class="fa-solid fa-sign-out-alt"></i> Logout</a></li>
            </ul>
        </div>

        <!-- Main Content -->
        <div class="main-content">
            <button class="toggle-sidebar" id="toggleBtn" style="display:none;">
                <i class="fa-solid fa-bars"></i>
            </button>

            <div class="header-section">
                <div>
                    <h1 id="pageTitle">Dashboard</h1>
                </div>
                <div class="admin-profile">
                    <div class="avatar"><?php echo strtoupper(substr($_SESSION['admin_name'] ?? 'A', 0, 1)); ?></div>
                    <div>
                        <strong style="color: #0f172a;"><?php echo htmlspecialchars($_SESSION['admin_name'] ?? 'Admin'); ?></strong><br>
                        <small style="color: #64748b;">Admin Panel</small>
                    </div>
                </div>
            </div>

            <!-- TAB 1: Dashboard Overview -->
            <div id="dashboard" class="tab-content active">
                <div class="content-section">
                    <h2 style="margin-bottom: 30px;">Dashboard Overview</h2>
                    <div id="dashboardStats" class="loading">
                        <div class="spinner"></div>
                        Loading statistics...
                    </div>
                </div>

                <div class="content-section">
                    <div class="section-header">
                        <h2>Recent Reservations</h2>
                    </div>
                    <div id="recentBookings" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading reservations...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 2: Profile -->
            <div id="profile" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>My Profile</h2>
                        <button class="btn-primary-custom" onclick="openEditProfileModal()">Edit Profile</button>
                    </div>
                    <div id="profileContainer" class="loading">
                        <div class="spinner"></div>
                        Loading profile...
                    </div>
                </div>
            </div>

            <!-- TAB 3: Staff Management -->
            <div id="staff" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Staff Management</h2>
                        <button class="btn-primary-custom" onclick="openAddStaffModal()">Add Staff Member</button>
                    </div>

                    <div id="staffContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading staff members...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 4: Task Assignments -->
            <div id="assignments" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Staff Task Assignments</h2>
                        <button class="btn-primary-custom" onclick="openAssignTaskModal()">Assign Task</button>
                    </div>

                    <div class="nav-tabs">
                        <button class="nav-tab active" onclick="filterAssignments('all')" style="padding: 8px 16px; background: var(--light-bg); border: 1px solid var(--border-color); border-radius: 6px; cursor: pointer; font-weight: 600; color: var(--primary-color);">All</button>
                        <button class="nav-tab" onclick="filterAssignments('pending')" style="padding: 8px 16px; background: transparent; border: 1px solid var(--border-color); border-radius: 6px; cursor: pointer; font-weight: 600;">Pending</button>
                        <button class="nav-tab" onclick="filterAssignments('in_progress')" style="padding: 8px 16px; background: transparent; border: 1px solid var(--border-color); border-radius: 6px; cursor: pointer; font-weight: 600;">In Progress</button>
                        <button class="nav-tab" onclick="filterAssignments('completed')" style="padding: 8px 16px; background: transparent; border: 1px solid var(--border-color); border-radius: 6px; cursor: pointer; font-weight: 600;">Completed</button>
                        <button class="nav-tab" onclick="filterAssignments('rejected')" style="padding: 8px 16px; background: transparent; border: 1px solid var(--border-color); border-radius: 6px; cursor: pointer; font-weight: 600;">Rejected</button>
                    </div>

                    <div id="assignmentsContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading assignments...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 5: Reservations/Bookings -->
            <div id="reservations" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Manage Reservations</h2>
                        <button class="btn-primary-custom" onclick="openAddBookingModal()">New Reservation</button>
                    </div>

                    <div class="nav-tabs">
                        <button class="nav-tab active" onclick="filterBookings('all')">All</button>
                        <button class="nav-tab" onclick="filterBookings('pending')">Pending</button>
                        <button class="nav-tab" onclick="filterBookings('confirmed')">Confirmed</button>
                        <button class="nav-tab" onclick="filterBookings('completed')">Completed</button>
                        <button class="nav-tab" onclick="filterBookings('cancelled')">Cancelled</button>
                    </div>

                    <div id="bookingsContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading reservations...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 6: Customers -->
            <div id="customers" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Customer Management</h2>
                        <button class="btn-primary-custom" onclick="openAddCustomerModal()">Add Customer</button>
                    </div>

                    <div id="customersContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading customers...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 4: Services -->
            <div id="services" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Service Management</h2>
                        <button class="btn-primary-custom" onclick="openAddServiceModal()">Add Service</button>
                    </div>

                    <div id="servicesContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading services...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 5: Team -->
            <div id="team" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Team Management</h2>
                        <button class="btn-primary-custom" onclick="openAddTeamModal()">Add Team Member</button>
                    </div>

                    <div id="teamContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading team members...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 6: Blog -->
            <div id="blog" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Blog Management</h2>
                        <button class="btn-primary-custom" onclick="openAddBlogModal()">Add Blog Post</button>
                    </div>

                    <div id="blogContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading blog posts...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 7: Gallery -->
            <div id="gallery" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Gallery Management</h2>
                        <button class="btn-primary-custom" onclick="openAddGalleryModal()">Add Image</button>
                    </div>

                    <div id="galleryContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading gallery...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 8: Contact Messages -->
            <div id="contact" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Contact Messages</h2>
                    </div>

                    <div id="contactContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading messages...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 9: Feedback/Reviews -->
            <div id="feedback" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Customer Feedback</h2>
                    </div>

                    <div id="feedbackContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading feedback...
                        </div>
                    </div>
                </div>
            </div>

            <!-- TAB 10: Hero Slider Management -->
            <div id="hero-slider" class="tab-content">
                <div class="content-section">
                    <div class="section-header">
                        <h2>Hero Slider Management</h2>
                        <button class="btn-primary-custom" onclick="openAddSlideModal()">
                            <i class="fa-solid fa-plus"></i> Add New Slide
                        </button>
                    </div>
                    <div id="sliderAlert"></div>

                    <div id="heroSliderContainer" class="data-table">
                        <div class="loading">
                            <div class="spinner"></div>
                            Loading hero slider slides...
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- MODALS -->

    <!-- Booking Modal -->
    <div class="modal-overlay" id="bookingModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="bookingModalTitle">Add Reservation</h3>
                <button class="modal-close" onclick="closeBookingModal()">&times;</button>
            </div>
            <div id="bookingModalAlert"></div>
            <form id="bookingForm">
                <input type="hidden" id="bookingId">
                <div class="form-row">
                    <div class="form-group">
                        <label>Customer</label>
                        <select id="bookingCustomer" class="form-control" required>
                            <option value="">Select Customer</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Service</label>
                        <select id="bookingService" class="form-control" required>
                            <option value="">Select Service</option>
                        </select>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Date</label>
                        <input type="date" id="bookingDate" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Time</label>
                        <input type="time" id="bookingTime" class="form-control" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>Address</label>
                    <textarea id="bookingAddress" class="form-control" rows="3"></textarea>
                </div>
                <div class="form-group">
                    <label>Notes</label>
                    <textarea id="bookingNotes" class="form-control" rows="2"></textarea>
                </div>
                <div class="form-group">
                    <label>Status</label>
                    <select id="bookingStatus" class="form-control">
                        <option value="pending">Pending</option>
                        <option value="confirmed">Confirmed</option>
                        <option value="completed">Completed</option>
                        <option value="cancelled">Cancelled</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeBookingModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Save Reservation</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Customer Modal -->
    <div class="modal-overlay" id="customerModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="customerModalTitle">Add Customer</h3>
                <button class="modal-close" onclick="closeCustomerModal()">&times;</button>
            </div>
            <div id="customerModalAlert"></div>
            <form id="customerForm">
                <input type="hidden" id="customerId">
                <div class="form-row">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" id="customerName" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" id="customerEmail" class="form-control" required>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Phone</label>
                        <input type="tel" id="customerPhone" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>City</label>
                        <input type="text" id="customerCity" class="form-control">
                    </div>
                </div>
                <div class="form-group">
                    <label>Address</label>
                    <textarea id="customerAddress" class="form-control" rows="2"></textarea>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeCustomerModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Save Customer</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Service Modal -->
    <div class="modal-overlay" id="serviceModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="serviceModalTitle">Add Service</h3>
                <button class="modal-close" onclick="closeServiceModal()">&times;</button>
            </div>
            <div id="serviceModalAlert"></div>
            <form id="serviceForm">
                <input type="hidden" id="serviceId">
                <div class="form-group">
                    <label>Service Name</label>
                    <input type="text" id="serviceName" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea id="serviceDescription" class="form-control" rows="3"></textarea>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Price ($)</label>
                        <input type="number" id="servicePrice" class="form-control" step="0.01" required>
                    </div>
                    <div class="form-group">
                        <label>Duration (minutes)</label>
                        <input type="number" id="serviceDuration" class="form-control" value="60">
                    </div>
                </div>
                <div class="form-group">
                    <label>Category</label>
                    <input type="text" id="serviceCategory" class="form-control">
                </div>
                <div class="form-group">
                    <label>Service Image</label>
                    <input type="file" id="serviceImage" class="form-control" accept="image/*">
                    <small style="color: #64748b;">Recommended size: 600x400px</small>
                    <div id="serviceImagePreview" style="margin-top: 10px; display: none;">
                        <img id="serviceImageImg" src="" style="max-width: 100%; height: auto; border-radius: 8px; max-height: 200px;">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeServiceModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Save Service</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Team Modal -->
    <div class="modal-overlay" id="teamModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="teamModalTitle">Add Team Member</h3>
                <button class="modal-close" onclick="closeTeamModal()">&times;</button>
            </div>
            <div id="teamModalAlert"></div>
            <form id="teamForm">
                <input type="hidden" id="teamId">
                <div class="form-row">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" id="teamName" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Position</label>
                        <input type="text" id="teamPosition" class="form-control">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" id="teamEmail" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Phone</label>
                        <input type="tel" id="teamPhone" class="form-control">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Specialization</label>
                        <input type="text" id="teamSpecialization" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Experience (years)</label>
                        <input type="number" id="teamExperience" class="form-control">
                    </div>
                </div>
                <div class="form-group">
                    <label>Team Member Photo</label>
                    <input type="file" id="teamImage" class="form-control" accept="image/*">
                    <small style="color: #64748b;">Recommended size: 400x500px</small>
                    <div id="teamImagePreview" style="margin-top: 10px; display: none;">
                        <img id="teamImageImg" src="" style="max-width: 100%; height: auto; border-radius: 8px; max-height: 200px;">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeTeamModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Save Team Member</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Blog Modal -->
    <div class="modal-overlay" id="blogModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="blogModalTitle">Add Blog Post</h3>
                <button class="modal-close" onclick="closeBlogModal()">&times;</button>
            </div>
            <div id="blogModalAlert"></div>
            <form id="blogForm">
                <input type="hidden" id="blogId">
                <div class="form-group">
                    <label>Title</label>
                    <input type="text" id="blogTitle" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Content</label>
                    <textarea id="blogContent" class="form-control" rows="5" required></textarea>
                </div>
                <div class="form-group">
                    <label>Category</label>
                    <input type="text" id="blogCategory" class="form-control">
                </div>
                <div class="form-group">
                    <label>Featured Image</label>
                    <input type="file" id="blogImage" class="form-control" accept="image/*">
                    <small style="color: #64748b;">Recommended size: 800x400px</small>
                    <div id="blogImagePreview" style="margin-top: 10px; display: none;">
                        <img id="blogImageImg" src="" style="max-width: 100%; height: auto; border-radius: 8px; max-height: 200px;">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeBlogModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Save Post</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Gallery Modal -->
    <div class="modal-overlay" id="galleryModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="galleryModalTitle">Add Gallery Image</h3>
                <button class="modal-close" onclick="closeGalleryModal()">&times;</button>
            </div>
            <div id="galleryModalAlert"></div>
            <form id="galleryForm">
                <input type="hidden" id="galleryId">
                <div class="form-group">
                    <label>Title</label>
                    <input type="text" id="galleryTitle" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea id="galleryDescription" class="form-control" rows="3"></textarea>
                </div>
                <div class="form-group">
                    <label>Upload Image</label>
                    <input type="file" id="galleryImage" class="form-control" accept="image/*" required>
                    <small style="color: #64748b;">Recommended size: 800x600px. Max 5MB</small>
                    <div id="galleryImagePreview" style="margin-top: 10px; display: none;">
                        <img id="galleryImageImg" src="" style="max-width: 100%; height: auto; border-radius: 8px; max-height: 250px;">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Service</label>
                        <select id="galleryService" class="form-control">
                            <option value="">Select Service</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Category</label>
                        <input type="text" id="galleryCategory" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeGalleryModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Save Image</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Profile Modal -->
    <div class="modal-overlay" id="profileModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="profileModalTitle">Edit Profile</h3>
                <button class="modal-close" onclick="closeProfileModal()">&times;</button>
            </div>
            <div id="profileModalAlert"></div>
            <form id="profileForm">
                <div class="form-group">
                    <label>Full Name</label>
                    <input type="text" id="profileName" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Email Address</label>
                    <input type="email" id="profileEmail" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Phone Number</label>
                    <input type="tel" id="profilePhone" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>New Password (Leave empty to keep current)</label>
                    <input type="password" id="profilePassword" class="form-control" placeholder="Enter new password">
                </div>
                <div class="form-group">
                    <label>Confirm Password</label>
                    <input type="password" id="profilePasswordConfirm" class="form-control" placeholder="Confirm password">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeProfileModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Save Changes</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Staff Modal -->
    <div class="modal-overlay" id="staffModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="staffModalTitle">Add Staff Member</h3>
                <button class="modal-close" onclick="closeStaffModal()">&times;</button>
            </div>
            <div id="staffModalAlert"></div>
            <form id="staffForm">
                <input type="hidden" id="staffId">
                <div class="form-group">
                    <label>Name</label>
                    <input type="text" id="staffName" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" id="staffEmail" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Password <span id="passwordRequired" style="color: #ef4444;">*</span></label>
                    <div style="position: relative;">
                        <input type="password" id="staffPassword" class="form-control" required>
                        <button type="button" class="btn-toggle-password" onclick="togglePasswordField('staffPassword')" style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; color: #109c3d;">
                            <i class="fa-solid fa-eye"></i>
                        </button>
                    </div>
                    <small id="passwordHint" style="color: #64748b; display: block; margin-top: 5px;">Min 8 characters. Required for new staff. Leave empty to keep current password when editing.</small>
                </div>
                <div class="form-group">
                    <label>Phone</label>
                    <input type="tel" id="staffPhone" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Position/Role</label>
                    <input type="text" id="staffPosition" class="form-control" placeholder="e.g., Cleaner, Supervisor" required>
                </div>
                <div class="form-group">
                    <label>Assigned Services</label>
                    <select id="staffServices" class="form-control" multiple style="height: 120px;">
                        <option value="">Select Services</option>
                    </select>
                    <small style="color: #64748b;">Hold Ctrl (or Cmd) to select multiple services</small>
                </div>
                <div class="form-group">
                    <label>Status</label>
                    <select id="staffStatus" class="form-control">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeStaffModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Save Staff Member</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Assign Task Modal -->
    <div class="modal-overlay" id="assignTaskModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="assignTaskTitle">Assign Task</h3>
                <button class="modal-close" onclick="closeAssignTaskModal()">&times;</button>
            </div>
            <div id="assignTaskAlert"></div>
            <form id="assignTaskForm">
                <div class="form-group">
                    <label for="assignTaskStaff">Select Staff Member <span style="color: var(--danger);">*</span></label>
                    <select id="assignTaskStaff" class="form-control" required>
                        <option value="">-- Select Staff Member --</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="assignTaskDesc">Task Description <span style="color: var(--danger);">*</span></label>
                    <textarea id="assignTaskDesc" class="form-control" required placeholder="Enter detailed task information..."></textarea>
                </div>
                <div class="form-group">
                    <label for="assignTaskPriority">Priority <span style="color: var(--danger);">*</span></label>
                    <select id="assignTaskPriority" class="form-control" required>
                        <option value="low">Low Priority</option>
                        <option value="medium" selected>Medium Priority</option>
                        <option value="high">High Priority</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="assignTaskDueDate">Due Date <span style="color: var(--danger);">*</span></label>
                    <input type="date" id="assignTaskDueDate" class="form-control" required>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeAssignTaskModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Assign Task</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Task Status Update Modal -->
    <div class="modal-overlay" id="taskDetailsModal">
        <div class="modal-content" style="max-width: 600px;">
            <div class="modal-header">
                <h3>Task Assignment Details</h3>
                <button class="modal-close" onclick="closeTaskDetailsModal()">&times;</button>
            </div>
            <div id="taskDetailsAlert"></div>
            <div id="taskDetailsContainer">
                <!-- Task details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-modal-cancel" onclick="closeTaskDetailsModal()">Close</button>
            </div>
        </div>
    </div>

    <!-- Hero Slider Management Modal -->
    <div class="modal-overlay" id="heroSliderModal">
        <div class="modal-content" style="max-width: 700px; width: 90%; max-height: 85vh; overflow-y: auto;">
            <div class="modal-header">
                <h3 id="heroSliderModalTitle">Add Hero Slide</h3>
                <button class="modal-close" onclick="closeHeroSliderModal()">&times;</button>
            </div>
            <div id="heroSliderModalAlert"></div>
            <form id="heroSliderForm">
                <input type="hidden" id="sliderSlideId">
                
                <div class="form-group">
                    <label>Slide Title <span style="color: var(--danger);">*</span></label>
                    <input type="text" id="sliderTitle" class="form-control" required placeholder="e.g., Professional Cleaning Services">
                </div>

                <div class="form-group">
                    <label>Description <span style="color: var(--danger);">*</span></label>
                    <textarea id="sliderDescription" class="form-control" required rows="4" placeholder="Enter slide description..."></textarea>
                </div>

                <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label>Badge Text</label>
                        <input type="text" id="sliderBadge" class="form-control" placeholder="e.g., Excellence in Service">
                    </div>
                    <div class="form-group">
                        <label>Badge Icon <span style="font-size: 12px; color: #64748b;">(FontAwesome)</span></label>
                        <input type="text" id="sliderBadgeIcon" class="form-control" placeholder="e.g., fa-check-circle" value="fa-star">
                    </div>
                </div>

                <div class="form-group">
                    <label style="font-weight: 600; margin-bottom: 10px; display: block;">Button 1</label>
                    <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 10px;">
                        <div>
                            <label style="font-size: 12px;">Text</label>
                            <input type="text" id="sliderBtn1Text" class="form-control" placeholder="Button text">
                        </div>
                        <div>
                            <label style="font-size: 12px;">URL</label>
                            <input type="text" id="sliderBtn1Url" class="form-control" placeholder="/page.php">
                        </div>
                        <div>
                            <label style="font-size: 12px;">Type</label>
                            <select id="sliderBtn1Type" class="form-control">
                                <option value="primary">Primary</option>
                                <option value="secondary">Secondary</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label style="font-weight: 600; margin-bottom: 10px; display: block;">Button 2</label>
                    <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 10px;">
                        <div>
                            <label style="font-size: 12px;">Text</label>
                            <input type="text" id="sliderBtn2Text" class="form-control" placeholder="Button text">
                        </div>
                        <div>
                            <label style="font-size: 12px;">URL</label>
                            <input type="text" id="sliderBtn2Url" class="form-control" placeholder="/page.php">
                        </div>
                        <div>
                            <label style="font-size: 12px;">Type</label>
                            <select id="sliderBtn2Type" class="form-control">
                                <option value="primary">Primary</option>
                                <option value="secondary" selected>Secondary</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label style="font-weight: 600; margin-bottom: 10px; display: block;">Statistics</label>
                    <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-bottom: 10px;">
                        <div>
                            <label style="font-size: 12px;">Stat 1 Number</label>
                            <input type="number" id="sliderStat1Number" class="form-control" placeholder="e.g., 500">
                        </div>
                        <div>
                            <label style="font-size: 12px;">Stat 1 Label</label>
                            <input type="text" id="sliderStat1Label" class="form-control" placeholder="e.g., Happy Clients">
                        </div>
                    </div>
                    <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-bottom: 10px;">
                        <div>
                            <label style="font-size: 12px;">Stat 2 Number</label>
                            <input type="number" id="sliderStat2Number" class="form-control" placeholder="e.g., 10">
                        </div>
                        <div>
                            <label style="font-size: 12px;">Stat 2 Label</label>
                            <input type="text" id="sliderStat2Label" class="form-control" placeholder="e.g., Years Experience">
                        </div>
                    </div>
                    <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 10px;">
                        <div>
                            <label style="font-size: 12px;">Stat 3 Number</label>
                            <input type="number" id="sliderStat3Number" class="form-control" placeholder="e.g., 98">
                        </div>
                        <div>
                            <label style="font-size: 12px;">Stat 3 Label</label>
                            <input type="text" id="sliderStat3Label" class="form-control" placeholder="e.g., Satisfaction Rate">
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label style="font-weight: 600; margin-bottom: 10px; display: block;">Background Image</label>
                    <div class="image-upload-section bg-upload" style="border: 2px dashed #109c3d; border-radius: 8px; padding: 20px; text-align: center; background: #f8fbff; cursor: pointer; transition: all 0.3s ease;" onclick="document.getElementById('sliderBgImage').click()">
                        <i class="fa-solid fa-image" style="font-size: 40px; color: #109c3d; margin-bottom: 10px;"></i>
                        <p style="margin: 0; color: #0f172a; font-weight: 600;">Click to upload or drag and drop</p>
                        <p style="margin: 5px 0 0 0; color: #64748b; font-size: 12px;">Background Image (Max 5MB)</p>
                    </div>
                    <input type="file" id="sliderBgImage" class="form-control" accept="image/*" style="display: none;">
                    <div id="sliderBgImagePreview" style="margin-top: 15px; display: none;">
                        <img id="bgImagePreviewImg" src="" style="max-width: 100%; max-height: 200px; border-radius: 8px; border: 1px solid #ddd;">
                        <button type="button" class="btn-danger" onclick="clearBgImagePreview()" style="width: 100%; margin-top: 10px; padding: 10px; background: #ef4444; color: white; border: none; border-radius: 6px; cursor: pointer;">Remove Image</button>
                    </div>
                </div>

                <div class="form-group">
                    <label style="font-weight: 600; margin-bottom: 10px; display: block;">Hero Image (Right Side)</label>
                    <div class="image-upload-section hero-upload" style="border: 2px dashed #3b82f6; border-radius: 8px; padding: 20px; text-align: center; background: #eff6ff; cursor: pointer; transition: all 0.3s ease;" onclick="document.getElementById('sliderHeroImage').click()">
                        <i class="fa-solid fa-person-hiking" style="font-size: 40px; color: #3b82f6; margin-bottom: 10px;"></i>
                        <p style="margin: 0; color: #0f172a; font-weight: 600;">Click to upload or drag and drop</p>
                        <p style="margin: 5px 0 0 0; color: #64748b; font-size: 12px;">Hero Character Image (Max 5MB)</p>
                    </div>
                    <input type="file" id="sliderHeroImage" class="form-control" accept="image/*" style="display: none;">
                    <div id="sliderHeroImagePreview" style="margin-top: 15px; display: none;">
                        <img id="heroImagePreviewImg" src="" style="max-width: 100%; max-height: 200px; border-radius: 8px; border: 1px solid #ddd;">
                        <button type="button" class="btn-danger" onclick="clearHeroImagePreview()" style="width: 100%; margin-top: 10px; padding: 10px; background: #ef4444; color: white; border: none; border-radius: 6px; cursor: pointer;">Remove Image</button>
                    </div>
                </div>

                <div class="form-row" style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                    <div class="form-group">
                        <label>Slide Order</label>
                        <input type="number" id="sliderOrder" class="form-control" value="1" min="1">
                    </div>
                    <div class="form-group">
                        <label>Status</label>
                        <select id="sliderActive" class="form-control">
                            <option value="1" selected>Active</option>
                            <option value="0">Inactive</option>
                        </select>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn-modal-cancel" onclick="closeHeroSliderModal()">Cancel</button>
                    <button type="submit" class="btn-modal-submit">Save Slide</button>
                </div>
            </form>
        </div>
    </div>

    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="admin-dashboard.js"></script>
    
    <!-- Hero Slider Management Script -->
    <script>
        // Open/Close Modal Functions
        function openAddSlideModal() {
            document.getElementById('sliderSlideId').value = '';
            document.getElementById('heroSliderForm').reset();
            resetImageUploads();
            document.getElementById('heroSliderModalTitle').textContent = 'Add New Hero Slide';
            document.getElementById('heroSliderModal').style.display = 'flex';
        }

        function openEditSlideModal(id) {
            fetch('hero_slider_handler.php?action=get_one&id=' + id)
                .then(response => {
                    if (!response.ok) {
                        throw new Error('HTTP error, status = ' + response.status);
                    }
                    return response.text();
                })
                .then(text => {
                    try {
                        const data = JSON.parse(text);
                        if (data.success) {
                            const slide = data.data;
                            document.getElementById('sliderSlideId').value = slide.id;
                            document.getElementById('sliderTitle').value = slide.title;
                            document.getElementById('sliderDescription').value = slide.description;
                            document.getElementById('sliderBadge').value = slide.badge || '';
                            document.getElementById('sliderBadgeIcon').value = slide.badge_icon || 'fa-star';
                            document.getElementById('sliderBtn1Text').value = slide.button_1_text || '';
                            document.getElementById('sliderBtn1Url').value = slide.button_1_url || '';
                            document.getElementById('sliderBtn1Type').value = slide.button_1_type || 'primary';
                            document.getElementById('sliderBtn2Text').value = slide.button_2_text || '';
                            document.getElementById('sliderBtn2Url').value = slide.button_2_url || '';
                            document.getElementById('sliderBtn2Type').value = slide.button_2_type || 'secondary';
                            document.getElementById('sliderStat1Number').value = slide.stat_1_number || '';
                            document.getElementById('sliderStat1Label').value = slide.stat_1_label || '';
                            document.getElementById('sliderStat2Number').value = slide.stat_2_number || '';
                            document.getElementById('sliderStat2Label').value = slide.stat_2_label || '';
                            document.getElementById('sliderStat3Number').value = slide.stat_3_number || '';
                            document.getElementById('sliderStat3Label').value = slide.stat_3_label || '';
                            document.getElementById('sliderOrder').value = slide.slide_order || 1;
                            document.getElementById('sliderActive').value = slide.is_active || 1;
                            
                            // Load existing background image preview if available
                            if (slide.slide_bg_image) {
                                document.getElementById('bgImagePreviewImg').src = 'assets/uploads/hero-slider/' + slide.slide_bg_image;
                                document.getElementById('sliderBgImagePreview').style.display = 'block';
                            } else {
                                document.getElementById('sliderBgImagePreview').style.display = 'none';
                            }
                            
                            // Load existing hero image preview if available
                            if (slide.slide_hero_image) {
                                document.getElementById('heroImagePreviewImg').src = 'assets/uploads/hero-slider/' + slide.slide_hero_image;
                                document.getElementById('sliderHeroImagePreview').style.display = 'block';
                            } else {
                                document.getElementById('sliderHeroImagePreview').style.display = 'none';
                            }
                            
                            document.getElementById('heroSliderModalTitle').textContent = 'Edit Hero Slide';
                            document.getElementById('heroSliderModal').style.display = 'flex';
                        } else {
                            console.error('Error:', data.message);
                            alert('Error loading slide');
                        }
                    } catch (e) {
                        console.error('Response:', text);
                        alert('Error loading slide: Invalid server response');
                    }
                })
                .catch(error => {
                    console.error('Error loading slide:', error);
                    alert('Error loading slide: ' + error);
                });
        }

        function closeHeroSliderModal() {
            document.getElementById('heroSliderModal').style.display = 'none';
            document.getElementById('heroSliderModalAlert').innerHTML = '';
        }

        // Load Hero Slides
        function loadHeroSlides() {
            fetch('hero_slider_handler.php?action=get_all')
                .then(response => {
                    if (!response.ok) {
                        throw new Error('HTTP error, status = ' + response.status);
                    }
                    return response.text();
                })
                .then(text => {
                    try {
                        const data = JSON.parse(text);
                        if (data.success) {
                            renderHeroSlides(data.data);
                        } else {
                            showAlert('sliderAlert', data.message, 'danger');
                        }
                    } catch (e) {
                        console.error('Response:', text);
                        showAlert('sliderAlert', 'Error loading slides: Invalid server response', 'danger');
                    }
                })
                .catch(error => {
                    showAlert('sliderAlert', 'Error loading slides: ' + error, 'danger');
                });
        }

        function renderHeroSlides(slides) {
            let html = '<table><thead><tr><th>Background Image</th><th>Hero Image</th><th>Order</th><th>Title</th><th>Badge</th><th>Status</th><th>Actions</th></tr></thead><tbody>';
            
            if (slides.length === 0) {
                html += '<tr><td colspan="8" style="text-align: center; padding: 20px;">No slides found. <button class="btn-primary-custom" onclick="openAddSlideModal()" style="margin-left: 10px;">Add First Slide</button></td></tr>';
            } else {
                slides.forEach(slide => {
                    const status = slide.is_active ? '<span style="color: #109c3d; font-weight: 600;">Active</span>' : '<span style="color: #ef4444;">Inactive</span>';
                    
                    // Background Image
                    const bgImagePath = slide.slide_bg_image ? 'assets/uploads/hero-slider/' + slide.slide_bg_image : 'assets/img/bg/Gemini_Generated_Image_vdt1wsvdt1wsvdt1.png';
                    const bgImageHtml = '<img src="' + bgImagePath + '" alt="Background" style="width: 60px; height: 45px; object-fit: cover; border-radius: 4px;" title="Background Image">';
                    
                    // Hero Image
                    const heroImagePath = slide.slide_hero_image ? 'assets/uploads/hero-slider/' + slide.slide_hero_image : 'assets/img/placeholder.png';
                    const heroImageHtml = '<img src="' + heroImagePath + '" alt="Hero" style="width: 60px; height: 45px; object-fit: cover; border-radius: 4px;" title="Hero Character">';
                    
                    html += '<tr>';
                    html += '<td style="padding: 10px; text-align: center;">' + bgImageHtml + '</td>';
                    html += '<td style="padding: 10px; text-align: center;">' + heroImageHtml + '</td>';
                    html += '<td>' + slide.slide_order + '</td>';
                    html += '<td><strong>' + slide.title.substring(0, 30) + (slide.title.length > 30 ? '...' : '') + '</strong></td>';
                    html += '<td>' + (slide.badge || '-') + '</td>';
                    html += '<td>' + status + '</td>';
                    html += '<td>';
                    html += '<button class="btn-edit" onclick="openEditSlideModal(' + slide.id + ')"><i class="fa-solid fa-edit"></i> Edit</button>';
                    html += '<button class="btn-danger" onclick="deleteSlideConfirm(' + slide.id + ')"><i class="fa-solid fa-trash"></i> Delete</button>';
                    html += '</td>';
                    html += '</tr>';
                });
            }
            
            html += '</tbody></table>';
            document.getElementById('heroSliderContainer').innerHTML = html;
        }

        // Save Hero Slide (Add/Edit)
        document.getElementById('heroSliderForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const slideId = document.getElementById('sliderSlideId').value;
            const action = slideId ? 'edit' : 'add';
            
            const formData = new FormData();
            formData.append('action', action);
            formData.append('id', slideId || '0');
            formData.append('title', document.getElementById('sliderTitle').value);
            formData.append('description', document.getElementById('sliderDescription').value);
            formData.append('badge', document.getElementById('sliderBadge').value);
            formData.append('badge_icon', document.getElementById('sliderBadgeIcon').value);
            formData.append('button_1_text', document.getElementById('sliderBtn1Text').value);
            formData.append('button_1_url', document.getElementById('sliderBtn1Url').value);
            formData.append('button_1_type', document.getElementById('sliderBtn1Type').value);
            formData.append('button_2_text', document.getElementById('sliderBtn2Text').value);
            formData.append('button_2_url', document.getElementById('sliderBtn2Url').value);
            formData.append('button_2_type', document.getElementById('sliderBtn2Type').value);
            formData.append('stat_1_number', document.getElementById('sliderStat1Number').value);
            formData.append('stat_1_label', document.getElementById('sliderStat1Label').value);
            formData.append('stat_2_number', document.getElementById('sliderStat2Number').value);
            formData.append('stat_2_label', document.getElementById('sliderStat2Label').value);
            formData.append('stat_3_number', document.getElementById('sliderStat3Number').value);
            formData.append('stat_3_label', document.getElementById('sliderStat3Label').value);
            formData.append('slide_order', document.getElementById('sliderOrder').value);
            formData.append('is_active', document.getElementById('sliderActive').value);
            
            // Add image files if selected
            if (window.sliderBgImageFile) {
                formData.append('slide_bg_image', window.sliderBgImageFile);
            }
            
            if (window.sliderHeroImageFile) {
                formData.append('slide_hero_image', window.sliderHeroImageFile);
            }
            
            fetch('hero_slider_handler.php', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                // Check if response is OK
                if (!response.ok) {
                    throw new Error('HTTP error, status = ' + response.status);
                }
                return response.text();
            })
            .then(text => {
                // Try to parse as JSON
                try {
                    const data = JSON.parse(text);
                    if (data.success) {
                        showAlert('heroSliderModalAlert', data.message, 'success');
                        setTimeout(() => {
                            closeHeroSliderModal();
                            loadHeroSlides();
                        }, 1500);
                    } else {
                        showAlert('heroSliderModalAlert', data.message || 'Unknown error occurred', 'danger');
                    }
                } catch (e) {
                    // If JSON parsing fails, show the raw response
                    console.error('Response:', text);
                    showAlert('heroSliderModalAlert', 'Error: Invalid response from server. Check console for details.', 'danger');
                }
            })
            .catch(error => {
                console.error('Fetch error:', error);
                showAlert('heroSliderModalAlert', 'Error: ' + error.message, 'danger');
            });
        });

        // Delete Hero Slide
        function deleteSlideConfirm(id) {
            if (confirm('Are you sure you want to delete this slide? This action cannot be undone.')) {
                deleteSlide(id);
            }
        }

        function deleteSlide(id) {
            const formData = new FormData();
            formData.append('action', 'delete');
            formData.append('id', id);
            
            fetch('hero_slider_handler.php', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('HTTP error, status = ' + response.status);
                }
                return response.text();
            })
            .then(text => {
                try {
                    const data = JSON.parse(text);
                    if (data.success) {
                        showAlert('sliderAlert', 'Slide deleted successfully!', 'success');
                        loadHeroSlides();
                    } else {
                        showAlert('sliderAlert', data.message, 'danger');
                    }
                } catch (e) {
                    console.error('Response:', text);
                    showAlert('sliderAlert', 'Error deleting slide: Invalid server response', 'danger');
                }
            })
            .catch(error => {
                showAlert('sliderAlert', 'Error deleting slide: ' + error, 'danger');
            });
        }

        // Show Alert Helper
        function showAlert(elementId, message, type) {
            const element = document.getElementById(elementId);
            const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
            element.innerHTML = '<div style="padding: 15px; border-radius: 5px; margin-bottom: 15px; background: ' + (type === 'success' ? '#d1fae5' : '#fee2e2') + '; color: ' + (type === 'success' ? '#065f46' : '#991b1b') + '; border: 1px solid ' + (type === 'success' ? '#6ee7b7' : '#fca5a5') + ';">' + message + '</div>';
            setTimeout(() => {
                element.innerHTML = '';
            }, 5000);
        }

        // Image Upload Handlers for Hero Slider
        document.addEventListener('DOMContentLoaded', function() {
            // Background Image Upload
            const bgFileInput = document.getElementById('sliderBgImage');
            const bgUploadZone = document.querySelector('.bg-upload');

            if (bgFileInput) {
                bgFileInput.addEventListener('change', function(e) {
                    handleBgImageUpload(e.target.files[0]);
                });
            }

            if (bgUploadZone) {
                bgUploadZone.addEventListener('dragover', function(e) {
                    e.preventDefault();
                    bgUploadZone.style.borderColor = '#0f7938';
                    bgUploadZone.style.background = '#ecf9f1';
                });
                bgUploadZone.addEventListener('dragleave', function() {
                    bgUploadZone.style.borderColor = '#109c3d';
                    bgUploadZone.style.background = '#f8fbff';
                });
                bgUploadZone.addEventListener('drop', function(e) {
                    e.preventDefault();
                    bgUploadZone.style.borderColor = '#109c3d';
                    bgUploadZone.style.background = '#f8fbff';
                    if (e.dataTransfer.files.length > 0) {
                        handleBgImageUpload(e.dataTransfer.files[0]);
                    }
                });
            }

            // Hero Image Upload
            const heroFileInput = document.getElementById('sliderHeroImage');
            const heroUploadZone = document.querySelector('.hero-upload');

            if (heroFileInput) {
                heroFileInput.addEventListener('change', function(e) {
                    handleHeroImageUpload(e.target.files[0]);
                });
            }

            if (heroUploadZone) {
                heroUploadZone.addEventListener('dragover', function(e) {
                    e.preventDefault();
                    heroUploadZone.style.borderColor = '#0f7938';
                    heroUploadZone.style.background = '#ecfff1';
                });
                heroUploadZone.addEventListener('dragleave', function() {
                    heroUploadZone.style.borderColor = '#3b82f6';
                    heroUploadZone.style.background = '#eff6ff';
                });
                heroUploadZone.addEventListener('drop', function(e) {
                    e.preventDefault();
                    heroUploadZone.style.borderColor = '#3b82f6';
                    heroUploadZone.style.background = '#eff6ff';
                    if (e.dataTransfer.files.length > 0) {
                        handleHeroImageUpload(e.dataTransfer.files[0]);
                    }
                });
            }

            const heroSliderTab = document.querySelector('[data-tab="hero-slider"]');
            if (heroSliderTab) {
                heroSliderTab.addEventListener('click', loadHeroSlides);
            }
        });

        // Background Image Upload Handler
        function handleBgImageUpload(file) {
            if (!file) return;

            const allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
            if (!allowedTypes.includes(file.type)) {
                showAlert('heroSliderModalAlert', 'Please upload a valid image file (JPG, PNG, GIF, WebP)', 'danger');
                return;
            }

            const maxSize = 5 * 1024 * 1024;
            if (file.size > maxSize) {
                showAlert('heroSliderModalAlert', 'Image size must be less than 5MB', 'danger');
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('bgImagePreviewImg').src = e.target.result;
                document.getElementById('sliderBgImagePreview').style.display = 'block';
                window.sliderBgImageFile = file;
            };
            reader.readAsDataURL(file);
        }

        // Hero Image Upload Handler
        function handleHeroImageUpload(file) {
            if (!file) return;

            const allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
            if (!allowedTypes.includes(file.type)) {
                showAlert('heroSliderModalAlert', 'Please upload a valid image file (JPG, PNG, GIF, WebP)', 'danger');
                return;
            }

            const maxSize = 5 * 1024 * 1024;
            if (file.size > maxSize) {
                showAlert('heroSliderModalAlert', 'Image size must be less than 5MB', 'danger');
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('heroImagePreviewImg').src = e.target.result;
                document.getElementById('sliderHeroImagePreview').style.display = 'block';
                window.sliderHeroImageFile = file;
            };
            reader.readAsDataURL(file);
        }

        function clearBgImagePreview() {
            document.getElementById('sliderBgImage').value = '';
            document.getElementById('bgImagePreviewImg').src = '';
            document.getElementById('sliderBgImagePreview').style.display = 'none';
            window.sliderBgImageFile = null;
        }

        function clearHeroImagePreview() {
            document.getElementById('sliderHeroImage').value = '';
            document.getElementById('heroImagePreviewImg').src = '';
            document.getElementById('sliderHeroImagePreview').style.display = 'none';
            window.sliderHeroImageFile = null;
        }

        function resetImageUploads() {
            clearBgImagePreview();
            clearHeroImagePreview();
        }

        // Load hero slides when page loads
        document.addEventListener('DOMContentLoaded', function() {
            const heroSliderTab = document.querySelector('[data-tab="hero-slider"]');
            if (heroSliderTab) {
                heroSliderTab.addEventListener('click', loadHeroSlides);
            }
        });
    </script>
</body>
</html>
